# Maven Tutorial

>Contributors:
>
>Chen Junfeng



## Create a new project with Maven

Offcial: https://www.jetbrains.com/help/idea/maven-support.html#create_new_maven_project

1. In IDEA, click File -> New -> Project

2. Select **Maven**

   ![image-20210924215906212](assets/image-20210924215906212.png)

3. IDEA will do the rest.

4. Modify `pom.xml` to add dependencies.

   ![image-20210924220149776](assets/image-20210924220149776.png)

   ```xml
   <?xml version="1.0" encoding="UTF-8"?>
   <project xmlns="http://maven.apache.org/POM/4.0.0"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
       <modelVersion>4.0.0</modelVersion>
   
       <groupId>org.example</groupId>
       <artifactId>untitled-test</artifactId>
       <version>1.0-SNAPSHOT</version>
   
       <properties>
           <maven.compiler.source>16</maven.compiler.source>
           <maven.compiler.target>16</maven.compiler.target>
       </properties>
       
       <dependencies>
           <!-- Add your dependency here -->
         
       </dependencies>
   
   </project>
   ```

5. Add postgresql driver and gson

   How to find maven configurations for some dependency? 

   ​		Google: `maven+dependency name`, then you will get what you need.

   Gson:

   ```xml
   <!-- https://mvnrepository.com/artifact/com.google.code.gson/gson -->
   <dependency>
       <groupId>com.google.code.gson</groupId>
       <artifactId>gson</artifactId>
       <version>2.8.8</version>
   </dependency>
   ```

   PostgreSQL Driver:

   ```xml
   <!-- https://mvnrepository.com/artifact/org.postgresql/postgresql -->
   <dependency>
       <groupId>org.postgresql</groupId>
       <artifactId>postgresql</artifactId>
       <version>42.2.24</version>
   </dependency>
   ```

6. `pom.xml`:

   ```xml
   <?xml version="1.0" encoding="UTF-8"?>
   <project xmlns="http://maven.apache.org/POM/4.0.0"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
       <modelVersion>4.0.0</modelVersion>
   
       <groupId>org.example</groupId>
       <artifactId>untitled-test</artifactId>
       <version>1.0-SNAPSHOT</version>
   
       <properties>
           <maven.compiler.source>16</maven.compiler.source>
           <maven.compiler.target>16</maven.compiler.target>
       </properties>
   
       <dependencies>
           <!-- https://mvnrepository.com/artifact/com.google.code.gson/gson -->
           <dependency>
               <groupId>com.google.code.gson</groupId>
               <artifactId>gson</artifactId>
               <version>2.8.8</version>
           </dependency>
   
           <!-- https://mvnrepository.com/artifact/org.postgresql/postgresql -->
           <dependency>
               <groupId>org.postgresql</groupId>
               <artifactId>postgresql</artifactId>
               <version>42.2.24</version>
           </dependency>
       </dependencies>
   
   </project>
   ```

7. Load Maven Changes

   <img src="assets/image-20210924220915752.png" alt="image-20210924220915752" style="zoom: 67%;" />

   When there is no red in the dependencies section, all dependencies are resolved.

   

8. If you can't find this button, there is a shortcut in idea based IDE to find an action.

   Press the RIGHT SHIFT twice, input `maven`, then use TAB to switch tabs to **Actions**.

   <img src="assets/image-20210924221143602.png" alt="image-20210924221143602" style="zoom: 33%;" />

   ​	You will find the Maven action, then press ENTER to open it.

   <img src="assets/image-20210924221313921.png" alt="image-20210924221313921" style="zoom:50%;" />

   Select **Reload Project** and maven will resolve all dependencies.




## Add Maven support to existing project

https://www.jetbrains.com/help/idea/convert-a-regular-project-into-a-maven-project.html



## If you have Internet connection issue

Thanks to GFW.

Get a good proxy which brings you to the Internet, then see: https://blog.csdn.net/c5113620/article/details/103064538

